---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Not Found通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.RouterTree.NextCaller.pas` 行124 - FResponse.Send('Not Found').Status(THTTPStatus.NotFound)
- E-02: `src/Horse.Core.RouterTree.NextCaller.pas` 行130 - FResponse.Send('Not Found').Status(THTTPStatus.NotFound)
- E-03: `src/Horse.Core.RouterTree.pas` 行158 - AResponse.Send('Not Found').Status(THTTPStatus.NotFound)
- E-04: `src/Horse.Core.RouterTree.NextCaller.pas` 行123 - else (FCallBack.Count = 0 の場合)
- E-05: `src/Horse.Core.RouterTree.NextCaller.pas` 行129 - if not FFound^ then
- E-06: `src/Horse.Core.RouterTree.pas` 行157 - if Result and (AResponse.Status = THTTPStatus.MethodNotAllowed.ToInteger)
- E-07: `src/Horse.Core.RouterTree.pas` 行154 - LQueueNotFound := GetQueuePath('/*', False)
- E-08: `src/Horse.Commons.pas` 行49 - NotFound = 404
- E-09: `src/Horse.Core.RouterTree.NextCaller.pas` 行38 - FFound: ^Boolean
- E-10: `src/Horse.Core.RouterTree.pas` 行152 - if not Result then

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPステータス404が返却される | E-01, E-02, E-03, E-08 | ○ |
| C-02 | メッセージは「Not Found」 | E-01, E-02, E-03 | ○ |
| C-03 | FCallBack.Count = 0 の場合に404送信（箇所1） | E-01, E-04 | ○ |
| C-04 | FFound = False の場合に404送信（箇所2） | E-02, E-05 | ○ |
| C-05 | ワイルドカードフォールバックで405を404に置換（箇所3） | E-03, E-06 | ○ |
| C-06 | /*パターンでフォールバック検索 | E-07 | ○ |
| C-07 | THTTPStatus.NotFoundの値は404 | E-08 | ○ |
| C-08 | FFoundはポインタ型 | E-09 | ○ |
| C-09 | Result = False でフォールバック処理に入る | E-10 | ○ |
| C-10 | 404レスポンスは複数箇所から送信可能 | E-01, E-02, E-03 | ○ |
| C-11 | FResponse.SendとStatusのメソッドチェーン | E-01 | ○ |
| C-12 | 405が返された場合のみ404に置換 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `Horse.Core.RouterTree.NextCaller.pas`の行124で404エラーが送信されることを確認
- [ ] `Horse.Core.RouterTree.NextCaller.pas`の行130で404エラーが送信されることを確認
- [ ] `Horse.Core.RouterTree.pas`の行158で405から404への置換を確認
